/* This file has been generated by Fred's Fisher Price record creator v{VERSION} on {DATE_TIME}
 * http://www.instructables.com/id/3D-printing-records-for-a-Fisher-Price-toy-record-/
 *
 * Press F6 to view your model in OpenSCAD
 * Then you cn export as STL for printing
 */

// Configuration
$fn = 100;
hStock = 5;
rStock = 60.58;
oDrive = 21.8;
rDrive = 1.55;
hInset = 1;
rInset = 25.6;
hGroove = 1.2;
overlap = 0.2;

hasSecondSide = 0;

// Some very useful code by HarlanDMii
// http://www.thingiverse.com/thing:16193
// Disabled as some people had problems with it
// use <write.scad>

// Create disc
module createDisc() {
	union() {

		createBlank();

		// Add the notes for the song. This part is dynamically generated.
		// Autogenerated pins for music tracks
		pin(27.95,29.15,12.363930987505,0);
		pin(27.95,29.15,34.1821128056868,0);
		pin(27.95,29.15,56.0002946238686,0);
		pin(27.95,29.15,77.8184764420504,0);
		pin(27.95,29.15,99.6366582602322,0);
		pin(27.95,29.15,192.363930987505,0);
		pin(27.95,29.15,214.182112805687,0);
		pin(27.95,29.15,236.000294623869,0);
		pin(27.95,29.15,257.81847644205,0);
		pin(27.95,29.15,279.636658260232,0);
		pin(29.15,30.35,12.4988283020457,0);
		pin(29.15,30.35,56.1351919384093,0);
		pin(29.15,30.35,154.317010120227,0);
		pin(29.15,30.35,192.498828302046,0);
		pin(29.15,30.35,236.135191938409,0);
		pin(29.15,30.35,334.317010120228,0);
		pin(30.69,31.89,143.622151961285,0);
		pin(30.69,31.89,323.622151961285,0);
		pin(31.89,33.09,154.643949733959,0);
		pin(31.89,33.09,334.643949733959,0);
		pin(33.51,34.71,138.468530867402,0);
		pin(33.51,34.71,143.923076321948,0);
		pin(33.51,34.71,318.468530867402,0);
		pin(33.51,34.71,323.923076321948,0);
		pin(34.71,35.91,-3.25451743897088,0);
		pin(34.71,35.91,29.4727552883019,0);
		pin(34.71,35.91,45.8363916519382,0);
		pin(34.71,35.91,127.65457347012,0);
		pin(34.71,35.91,154.927300742847,0);
		pin(34.71,35.91,176.745482561029,0);
		pin(34.71,35.91,209.472755288302,0);
		pin(34.71,35.91,225.836391651938,0);
		pin(34.71,35.91,307.65457347012,0);
		pin(34.71,35.91,334.927300742847,0);
		pin(36.225,37.425,7.80573115211963,0);
		pin(36.225,37.425,24.169367515756,0);
		pin(36.225,37.425,35.0784584248469,0);
		pin(36.225,37.425,51.4420947884833,0);
		pin(36.225,37.425,78.7148220612105,0);
		pin(36.225,37.425,122.351185697574,0);
		pin(36.225,37.425,187.80573115212,0);
		pin(36.225,37.425,204.169367515756,0);
		pin(36.225,37.425,215.078458424847,0);
		pin(36.225,37.425,231.442094788483,0);
		pin(36.225,37.425,258.714822061211,0);
		pin(36.225,37.425,302.351185697574,0);
		pin(37.425,38.625,13.3421054730322,0);
		pin(37.425,38.625,73.3421054730321,0);
		pin(37.425,38.625,116.978469109396,0);
		pin(37.425,38.625,236.978469109396,0);
		pin(37.425,38.625,269.705741836669,0);
		pin(39.025,40.225,57.1153792567359,0);
		pin(39.025,40.225,89.8426519840087,0);
		pin(39.025,40.225,193.479015620372,0);
		pin(39.025,40.225,253.479015620372,0);
		pin(39.025,40.225,297.115379256736,0);
		pin(40.225,41.425,68.0953018599524,0);
		pin(40.225,41.425,111.731665496316,0);
		pin(40.225,41.425,275.36802913268,0);
		pin(41.8,43,95.4855462047319,0);
		pin(41.8,43,248.212818932005,0);
		pin(41.8,43,291.849182568368,0);
		pin(43,44.2,101.002074923118,0);
		pin(44.625,45.825,281.108143911572,0);

	}
}

// Create the blank, ready for dynamically added pins
module createBlank() {

	difference() {
	
		// stock
		cylinder(h=hStock, r=rStock);
	
		// top cutout
		translate(v = [0,0,hStock-hInset+overlap]) {
			cylinder(h=hInset + overlap, r=rInset);
		}

		// Bottom cutout lets the disc sit flatter, but some printers my struggle with the overhang
		translate(v = [0,0,-overlap]) {
			cylinder(h=hInset + overlap, r=rInset);
		}
		
		// Centre hole
		cylinder(h=hStock, r=3.22);

		// Drive holes
		translate(v = [0,oDrive,0]) { cylinder(h=hStock, r=rDrive); }
		translate(v = [0,-oDrive,0]) { cylinder(h=hStock, r=rDrive); }
		translate(v = [oDrive,0,0]) { cylinder(h=hStock, r=rDrive); }
		translate(v = [-oDrive,0,0]) { cylinder(h=hStock, r=rDrive); }

		// Tracks - each one for two notes
		track(28.15, 0);
		track(30.89, 0);
		track(33.71, 0);
		track(36.425, 0);
		track(39.225, 0);
		track(42, 0);
		track(44.825, 0);
		track(47.555, 0);
		track(50.315, 0);
		track(53.11, 0);
		track(55.9, 0);

		if (hasSecondSide > 0) {
			track(28.15, 1);
			track(30.89, 1);
			track(33.71, 1);
			track(36.425, 1);
			track(39.225, 1);
			track(42, 1);
			track(44.825, 1);
			track(47.555, 1);
			track(50.315, 1);
			track(53.11, 1);
			track(55.9, 1);
		}
	}
}

// Negative for a double track
module track(inner, onSecondSide) {
	if (onSecondSide > 0) {
		translate(v = [0,0,-overlap]) {
			difference() {
				cylinder(h=hGroove+overlap, r=inner+2);
				cylinder(h=hGroove+overlap, r=inner);
			}
		}
	}
	else {
		translate(v = [0,0,hStock-hGroove]) {
			difference() {
				cylinder(h=hGroove+overlap, r=inner+2);
				cylinder(h=hGroove+overlap, r=inner);
			}
		}
	}

}

// Create a pin at a certain angle
module pin(inner, outer, angle, onSecondSide)
{
	rotate(a=angle) {
		if (onSecondSide > 0) {
			translate(v=[inner, -0.5, - overlap]) {
				# cube (size=[outer-inner, 1 ,hGroove + overlap], center=false);
			}
		} else {
			translate(v=[inner, -0.5, hStock - hGroove - overlap]) {
				# cube (size=[outer-inner, 1 ,hGroove + overlap], center=false);
			}
		}
	}
}

// Add text
module title(text, onSecondSide)
{
// Disabled as some people had trouble with it
//	if (onSecondSide>0)
//		writecylinder(text, [0,0,-hInset], radius=20, height=hStock-hInset, h=3, t=hInset, face="bottom");
//	else
//		writecylinder(text, [0,0,0], radius=20, height=hStock-hInset, h=3, t=hInset, face="top");
}

// Do the work
createDisc();
